<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Ward;
use DB;
use App\Swachha_Bharat;
use App\Feedback_Form;
class FeedbackReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
      public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        return view("feedback_report/report",compact('ward_data'));
    }

    public function display_report(Request $req)
    {
      DB::enableQueryLog();
      $ward= $req->ward;
      $created_at= $req->created_at;
      //$ra=DB::table('survey_feedback')->whereRaw('Date(created_at)' '=' ,$created_at)->where('ward', $ward)->sum('rating');
      //$total_rating = Feedback_Form::whereRaw()->sum('rating');
      $sum = Feedback_Form::where('ward', $ward)->get();
      $sum= DB::select("SELECT sum(rating) as avg_rating FROM `survey_feedback` WHERE ward='$ward' AND Date(created_at)='$created_at'");
      $total_rating= $sum['0']->avg_rating;
      $rec1 = DB::table('survey_feedback')->select( DB::raw('rating'))->get();
      $total_rating_cnt=count($rec1);
      $avg_rating=$total_rating/$total_rating_cnt;
      
   
      if($ward=="all")
      {
      $final_report=DB::select("SELECT swachha_bharat_survey.title,mst_ward.ward,
        COUNT(IF(running_water = 'yes',1,null)) as q1yes_cnt,
        COUNT(IF(running_water = 'no',1,null)) as q1no_cnt,

        COUNT(IF(electric_lights_working = 'yes',1,null)) as q3yes_cnt,
        COUNT(IF(electric_lights_working = 'no',1,null)) as q3no_cnt,

        COUNT(IF(mirror_in_toilet = 'yes',1,null)) as q4yes_cnt,
        COUNT(IF(mirror_in_toilet = 'no',1,null)) as q4no_cnt,

        COUNT(IF(google_locator = 'yes',1,null)) as q5yes_cnt,
        COUNT(IF(google_locator = 'no',1,null)) as q5no_cnt,
        COUNT(rating) as total_rating,
        SUM(rating)/ COUNT(rating) as avgrating
        FROM `survey_feedback` LEFT JOIN swachha_bharat_survey on survey_feedback.swachha_id=swachha_bharat_survey.swachha_id JOIN mst_ward ON survey_feedback.ward=mst_ward.id  WHERE Date(survey_feedback.created_at)='$created_at' AND  swachha_bharat_survey.deleted_at IS NULL GROUP BY survey_feedback.swachha_id");
        
        // $query = DB::getQueryLog();
        // $query = end($query);
        // print_r($query);
        // exit();
           
      }
      else
      {
        $final_report=DB::select("SELECT swachha_bharat_survey.title,mst_ward.ward,
        COUNT(IF(running_water = 'yes',1,null)) as q1yes_cnt,
        COUNT(IF(running_water = 'no',1,null)) as q1no_cnt,

        COUNT(IF(electric_lights_working = 'yes',1,null)) as q3yes_cnt,
        COUNT(IF(electric_lights_working = 'no',1,null)) as q3no_cnt,

        COUNT(IF(mirror_in_toilet = 'yes',1,null)) as q4yes_cnt,
        COUNT(IF(mirror_in_toilet = 'no',1,null)) as q4no_cnt,

        COUNT(IF(google_locator = 'yes',1,null)) as q5yes_cnt,
        COUNT(IF(google_locator = 'no',1,null)) as q5no_cnt,
        COUNT(rating) as total_rating,
        SUM(rating)/ COUNT(rating) as avgrating
        FROM `survey_feedback` LEFT JOIN swachha_bharat_survey on survey_feedback.swachha_id=swachha_bharat_survey.swachha_id JOIN mst_ward ON survey_feedback.ward=mst_ward.id WHERE survey_feedback.ward='$ward' AND swachha_bharat_survey.deleted_at IS NULL AND Date(survey_feedback.created_at)='$created_at' GROUP BY survey_feedback.swachha_id");   
      }
      
     
        $reportData['data']=$final_report;
        echo json_encode($reportData);
         exit;

       
    }

    public function downloadExcelFile(Request $req,$type){
   
      $ward= $req->hidden_ward;
      $created_at= $req->hidden_created_at;
     if($ward=="all")
      {
      $final_report=DB::select("SELECT swachha_bharat_survey.title,mst_ward.ward,
        COUNT(IF(running_water = 'yes',1,null)) as q1yes_cnt,
        COUNT(IF(running_water = 'no',1,null)) as q1no_cnt,

        COUNT(IF(electric_lights_working = 'yes',1,null)) as q3yes_cnt,
        COUNT(IF(electric_lights_working = 'no',1,null)) as q3no_cnt,

        COUNT(IF(mirror_in_toilet = 'yes',1,null)) as q4yes_cnt,
        COUNT(IF(mirror_in_toilet = 'no',1,null)) as q4no_cnt,

        COUNT(IF(google_locator = 'yes',1,null)) as q5yes_cnt,
        COUNT(IF(google_locator = 'no',1,null)) as q5no_cnt,
        COUNT(rating) as total_rating,
        SUM(rating)/ COUNT(rating) as avgrating
        FROM `survey_feedback` LEFT JOIN swachha_bharat_survey on survey_feedback.swachha_id=swachha_bharat_survey.swachha_id JOIN mst_ward ON survey_feedback.ward=mst_ward.id  WHERE Date(survey_feedback.created_at)='$created_at' AND  swachha_bharat_survey.deleted_at IS NULL GROUP BY survey_feedback.swachha_id");
            
      }
      else
      {
        $final_report=DB::select("SELECT swachha_bharat_survey.title,mst_ward.ward,
        COUNT(IF(running_water = 'yes',1,null)) as q1yes_cnt,
        COUNT(IF(running_water = 'no',1,null)) as q1no_cnt,

        COUNT(IF(electric_lights_working = 'yes',1,null)) as q3yes_cnt,
        COUNT(IF(electric_lights_working = 'no',1,null)) as q3no_cnt,

        COUNT(IF(mirror_in_toilet = 'yes',1,null)) as q4yes_cnt,
        COUNT(IF(mirror_in_toilet = 'no',1,null)) as q4no_cnt,

        COUNT(IF(google_locator = 'yes',1,null)) as q5yes_cnt,
        COUNT(IF(google_locator = 'no',1,null)) as q5no_cnt,
        COUNT(rating) as total_rating,
        SUM(rating)/ COUNT(rating) as avgrating
        FROM `survey_feedback` LEFT JOIN swachha_bharat_survey on survey_feedback.swachha_id=swachha_bharat_survey.swachha_id JOIN mst_ward ON survey_feedback.ward=mst_ward.id WHERE survey_feedback.ward='$ward' AND swachha_bharat_survey.deleted_at IS NULL AND Date(survey_feedback.created_at)='$created_at' GROUP BY survey_feedback.swachha_id");   
      }
      
       $data = array();
      foreach ($final_report as $key=> $final) {
       $data[] = (array)$final;  
      
    }

     if(count($data) == '0') 
    {
      
      return redirect()->back()->with('dataError','Data not available');
    }
    foreach($data as $key=> $row) {
    $avgrating=$row['avgrating'];
    $ra=round($avgrating);
    $data_arr[] = array(
     'Sr. No.'=>$key+1,
     'Toilet Name' => $row['title'],
     'Ward' => $row['ward'],
     'Date'=>$created_at,
     'Running Water (Yes)'=> $row['q1yes_cnt'],
     'Running Water (No)'=>$row['q1no_cnt'],
     'Electric Lights Working (Yes)'=> $row['q3yes_cnt'],
     'Electric Lights Working (No)'=> $row['q3no_cnt'],
     'Mirror In Toilet(Yes)'=>$row['q4yes_cnt'],
     'Mirror In Toilet(No)'=>$row['q4no_cnt'],
     'Google Locator (Yes)'=>$row['q5yes_cnt'],
     'Google Locator (No)'=>$row['q5no_cnt'],
     'Average Rating (Total Rating Count)' => $ra.'('.$row['total_rating'].')',
     );
    
    
   }
   
     return \Excel::create('Toilet_survey_'.$created_at, function($excel) use ($data_arr) {
            $excel->sheet('sheet name', function($sheet) use ($data_arr)
            {
              $sheet->setColumnFormat([
                    'D' => 'yyyy-mm-dd', // Booked At
                ]);
             
            $sheet->fromArray($data_arr,null,'A1',true);
            });
        })->download($type);

   
    } 


    
}
