@extends('adminlayouts.master')
@section('content')
<style>
table.table-bordered.dataTable th, table.table-bordered.dataTable td{
        word-break: normal !important;
}
</style>
<div class="container" style="max-width:95%">

						<!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Advertisement Hoarding Master</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
							   <li class="breadcrumb-item active" aria-current="page">Advertisement Hoarding Master </li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->
                        
                        
                        
						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
								 @if(Session::has('flash_message'))
							      <div class="alert alert-success">
							      {{ Session::get('flash_message') }}
							        </div>
							        @endif
							<div class="card">
								<div class="card-header">
								
									<div class="btn-list text-right">
										<a href="{{ url('/adv_hoarding/create/') }}" class="btn btn-primary"><i class="fa fa-plus" data-toggle="tooltip" title="" data-original-title="fa fa-plus"></i>Add Advertisement Hoarding</a>
									</div>
								</div>
								<div class="card-body">
                                	 <div class="table-responsive">
										<table id="example" class="table table-striped table-bordered">
											<thead>
												<tr>
													<th class="wd-10p">Id</th>
													<th class="wd-10p">Licence Number</th>
												    <th class="wd-15p">Advertiser's Name & Address</th>
												    <th class="wd-15p">Advertise Location</th>
												    <th class="wd-8p">Advertise Type </th>
												    <th style="width: 100px !important">Advertise Size</th>
												    <th class="wd-15p">Total Area</th>
												    <th class="wd-15p">Renewal Period</th>
												    <th class="wd-15p">Latitude</th>
												    <th class="wd-15p">Longitude</th>
												    <th class="wd-15p">Action</th>
													<th class="wd-15p">Qr Code</th>
												</tr>
											</thead>

											<tbody>
												@foreach($adv as $key => $ad)
												<tr>
													<td>{{($key+1)}}</td>
													<td>{{($ad->licence_no)}}</td>
													<td>{{($ad->advertiser_name)}}</td>
													<td>{{($ad->adv_loc)}}</td>
													<td style="white-space: nowrap;">
														@if($ad->adv_type == '1')
														प्रकाशित
														@elseif($ad->adv_type == '2')
														अप्रकाशित
														@endif

													</td>
													<td>{{$ad->adv_size}}</td>
													<td data-col-width="20">{{$ad->total_area}}</td>
													<td>{{$ad->renewal_period}}</td>
													<td style="white-space: nowrap;">{{$ad->latitude}}</td>
													<td style="white-space: nowrap;">{{$ad->longitude}}</td>
												    <td><a href="{{route('adv_hoarding.edit',$ad->id )}}" class="btn btn-square btn-primary mb-1"><i class="fa fa-edit" > </i></a>
													<form action="{{route('adv_hoarding.destroy',$ad->id)}}" method="post" style="display: inline-block;">
														 {!! method_field('delete') !!}
                                                         {!! csrf_field() !!}
							                            <button class="btn btn-square btn-danger  mb-1" type="submit"><i class="fa fa-trash" ></i></button>
													   
												    </form>
												    </td>
												    <td><a href="{{url('/downloadqr')}}/{{$ad->id}}" class="btn btn-square btn-primary   mb-1">QR PDF</a></td>
													
												</tr>
												@endforeach
												
											
											</tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection