<!doctype html>
<html lang="en" dir="ltr">
  <head>
        <meta charset="UTF-8">
        <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <meta name="msapplication-TileColor" content="#0061da">
        <meta name="theme-color" content="#1643a3">
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="mobile-web-app-capable" content="yes">
        <meta name="HandheldFriendly" content="True">
        <meta name="MobileOptimized" content="320">
        <link rel="icon" href="favicon.ico" type="image/x-icon"/>
        <link rel="shortcut icon" type="image/x-icon" href="favicon.ico" />

        <!-- Title -->
        <title>Advertisement Hoardings Login</title>
        
        <!-- Dashboard css -->
        <link href="<?php echo e(url('/')); ?>/assets/css/dashboard.css" rel="stylesheet" />
        
        <!-- Font family -->
        <link href="https://fonts.googleapis.com/css?family=Comfortaa:300,400,700" rel="stylesheet">

        <!-- C3 Charts css -->
        <link href="<?php echo e(url('/')); ?>/assets/plugins/charts-c3/c3-chart.css" rel="stylesheet" />

        <!-- Custom scroll bar css-->
        <link href="<?php echo e(url('/')); ?>/assets/plugins/scroll-bar/jquery.mCustomScrollbar.css" rel="stylesheet" />

        <!---Font icons css-->
        <link href="<?php echo e(url('/')); ?>/assets/plugins/iconfonts/plugin.css" rel="stylesheet" />
        <link  href="<?php echo e(url('/')); ?>/assets/fonts/fonts/font-awesome.min.css" rel="stylesheet">
        <!--<link  href="<?php echo e(url('/')); ?>/assets/css/app.css" rel="stylesheet">-->
        <link href="<?php echo e(url('/')); ?>/assets/plugins/sweet-alert/jquery.sweet-modal.min.css" rel="stylesheet" />
		<link href="<?php echo e(url('/')); ?>/assets/plugins/sweet-alert/sweetalert.css" rel="stylesheet" />

  </head>
    <body class="login-img">
        <div class="page ">

            <!-- page-single -->
            <div class="page-single">
                <div class="container">
                    <div class="row">
                        <div class="col mx-auto">
                            <div class="text-center mb-6">
                               	<img src="<?php echo e(url('/')); ?>/assets/images/logo.png" class="" alt="" style="height: 176px;">
                            </div>
                            <div class="row justify-content-center">
                                <div class="col-md-8 col-lg-6 col-xl-5 col-sm-7 ">
                                    <div class="card-group mb-0">
                                        <div class="card p-4">
                                            <div class="card-body">
                                                <form class="form-horizontal" method="POST" action="<?php echo e(route('login')); ?>">
                                                <?php echo e(csrf_field()); ?>

                                                <h1>Login</h1>
                                                <p class="text-muted">Sign In to your account</p>
                                                <div class="input-group mb-3 ">
                                                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                                                    <input type="email" id="email" type="email" class="form-control" placeholder="email" name="email" value="<?php echo e(old('email')); ?>">
                                                </div>
                                                <?php if($errors->has('email')): ?>
                                                        <span class="help-block" style="color: red">
                                                            <strong><?php echo e($errors->first('email')); ?></strong>
                                                        </span>
                                                 <?php endif; ?>
                                                <div class="input-group mb-4">
                                                    <span class="input-group-addon"><i class="fa fa-unlock-alt"></i></span>
                                                    <input type="password" class="form-control" placeholder="Password" name="password" id="password" >
                                                </div>
                                                <?php if($errors->has('password')): ?>
                                                        <span class="help-block" style="color: red">
                                                            <strong><?php echo e($errors->first('password')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <button type="submit" class="btn btn-gradient-primary btn-block">Login</button>
                                                    </div>
                                                    <div class="col-12">
														<a href="<?php echo e(url('resetpassword')); ?>" class="btn btn-link box-shadow-0 px-0">Forgot password?</a>
													</div>
                                                </div>
                                            </form>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- col end -->
                            </div><!-- row end -->
                        </div>
                    </div><!-- row end -->
                </div>
            </div>
            <!-- page-single end -->
        </div>

        <!-- Jquery js-->
        <script src="<?php echo e(url('/')); ?>/assets/js/vendors/jquery-3.2.1.min.js"></script>
        
        <!--Bootstrap js-->
        <script src="<?php echo e(url('/')); ?>/assets/js/vendors/bootstrap.bundle.min.js"></script>
        
        <!--Jquery Sparkline js-->
        <script src="<?php echo e(url('/')); ?>/assets/js/vendors/jquery.sparkline.min.js"></script>
        
        <!-- Chart Circle js-->
        <script src="<?php echo e(url('/')); ?>/assets/js/vendors/circle-progress.min.js"></script>
        
        <!-- Star Rating js-->
        <script src="<?php echo e(url('/')); ?>/assets/plugins/rating/jquery.rating-stars.js"></script>
        
        <!-- Custom scroll bar js-->
        <script src="<?php echo e(url('/')); ?>/assets/plugins/scroll-bar/jquery.mCustomScrollbar.concat.min.js"></script>
        <script src="<?php echo e(url('/')); ?>/assets/plugins/sweet-alert/jquery.sweet-modal.min.js"></script>
		<script src="<?php echo e(url('/')); ?>/assets/plugins/sweet-alert/sweetalert.min.js"></script>
		<script src="<?php echo e(url('/')); ?>/assets/js/sweet-alert.js"></script>
		 <script>
        $(document).ready(function(){
           // alert("j");
            var msg = '<?php echo e(Session::get('serverError')); ?>';
            var exist = '<?php echo e(Session::has('serverError')); ?>';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
				// confirmButtonText: 'Exit',
				// cancelButtonText: 'Stay on the page'
			},
			function(){ 
              location.reload();
              // window.location.href='http://localhost/Swachha_Bharat/login';
 
              });
           
            }
          


            //alert("The paragraph was clicked.");

         
        });
        </script>

    </body>
</html>
