<!doctype html>
<html lang="en" dir="ltr">
  <head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">

		<meta name="msapplication-TileColor" content="#0061da">
		<meta name="theme-color" content="#1643a3">
		<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="mobile-web-app-capable" content="yes">
		<meta name="HandheldFriendly" content="True">
		<meta name="MobileOptimized" content="320">
		<link rel="icon" href="favicon.ico" type="image/x-icon"/>
		<link rel="shortcut icon" type="image/x-icon" href="favicon.ico" />

		<!-- Title -->
		<!-- Title -->
		<title>Register-Water Management</title>
		
		<!-- Dashboard css -->
		<link href="<?php echo e(url('/')); ?>/assets/css/dashboard.css" rel="stylesheet" />
		
		<!-- Font family -->
		<link href="https://fonts.googleapis.com/css?family=Comfortaa:300,400,700" rel="stylesheet">

		<!-- C3 Charts css -->
		<link href="<?php echo e(url('/')); ?>/assets/plugins/charts-c3/c3-chart.css" rel="stylesheet" />

		<!-- Custom scroll bar css-->
		<link href="<?php echo e(url('/')); ?>/assets/plugins/scroll-bar/jquery.mCustomScrollbar.css" rel="stylesheet" />

		<!---Font icons css-->
		<link href="<?php echo e(url('/')); ?>/assets/plugins/iconfonts/plugin.css" rel="stylesheet" />
		<link  href="<?php echo e(url('/')); ?>/assets/fonts/fonts/font-awesome.min.css" rel="stylesheet">

	</head>
	<body class="login-img">
		<div class="page ">

		    <!-- page-single -->
			<div class="page-single">
				<div class="container">
				    <!-- row -->
					<div class="row">
						<div class="col mx-auto">
							<div class="text-center mb-6">
								<img src="assets/images/brand/logo-light.png" class="" alt="">
							</div>
							<div class="row justify-content-center">
								<div class="col-md-8 col-lg-6 col-xl-5 col-sm-7">
									<div class="card-group mb-0">
										<div class="card p-4">
											<div class="card-body">
												<form class="form-horizontal" method="POST" action="<?php echo e(route('register')); ?>">
                        						<?php echo e(csrf_field()); ?>

                                                <h1>Register</h1>
												<p class="text-muted">Create New Account</p>
												<div class="input-group mb-3">
													<span class="input-group-addon"><i class="fa fa-user w-4"></i></span>
													<input type="text" class="form-control <?php echo e($errors->has('name') ? ' is-invalid state-invalid' : ''); ?>" placeholder="Enter Name" name="name" value="<?php echo e(old('name')); ?>" required autofocus>
													<?php if($errors->has('name')): ?>
						                                <div class="invalid-feedback">
						                                    <strong><?php echo e($errors->first('name')); ?></strong>
						                                </div>
						                            <?php endif; ?>
												</div>
												<div class="input-group mb-4">
													<span class="input-group-addon"><i class="fa fa-envelope  w-4"></i></span>
													<input type="text" class="form-control <?php echo e($errors->has('required') ? ' is-invalid state-invalid' : ''); ?>" placeholder="Enter Email" value="<?php echo e(old('email')); ?>" name="email" required>
													<?php if($errors->has('email')): ?>
					                                    <div class="invalid-feedback">
					                                        <strong><?php echo e($errors->first('email')); ?></strong>
					                                    </div>
					                                <?php endif; ?>
												</div>
												<div class="input-group mb-4">
													<span class="input-group-addon"><i class="fa fa-unlock-alt  w-4"></i></span>
													<input type="password" class="form-control <?php echo e($errors->has('password') ? ' is-invalid state-invalid' : ''); ?>" placeholder="Password" name="password" required>
													<?php if($errors->has('password')): ?>
					                                    <div class="invalid-feedback">
					                                        <strong><?php echo e($errors->first('password')); ?></strong>
					                                    </div>
					                                <?php endif; ?>
												</div>
												<div class="input-group mb-4">
													<span class="input-group-addon"><i class="fa fa-unlock-alt  w-4"></i></span>
													<input type="password" class="form-control " placeholder="Enter Confirm Password" id="password-confirm" name="password_confirmation" required>
												</div>
												<!-- <div class="form-group">
													<label class="custom-control custom-checkbox">
														<input type="checkbox" class="custom-control-input" />
														<span class="custom-control-label">Agree the <a href="terms.html">terms and policy</a></span>
													</label>
												</div> -->
												<div class="row">
													<div class="col-12">
														<button type="submit" class="btn btn-gradient-primary btn-block px-4">Create a new account</button>
													</div>
												</div>
											</form>
											</div>
										</div>
									</div>
								</div>
							</div><!-- row end -->
						</div>
					</div><!-- row end -->
				</div>
			</div>
			<!-- page-single end -->
		</div>
		
		<!-- Jquery js-->
		<script src="<?php echo e(url('/')); ?>/assets/js/vendors/jquery-3.2.1.min.js"></script>
		
		<!--Bootstrap js-->
		<script src="<?php echo e(url('/')); ?>/assets/js/vendors/bootstrap.bundle.min.js"></script>
		
		<!--Jquery Sparkline js-->
		<script src="<?php echo e(url('/')); ?>/assets/js/vendors/jquery.sparkline.min.js"></script>
		
		<!-- Chart Circle js-->
		<script src="<?php echo e(url('/')); ?>/assets/js/vendors/circle-progress.min.js"></script>
		
		<!-- Star Rating js-->
		<script src="<?php echo e(url('/')); ?>/assets/plugins/rating/jquery.rating-stars.js"></script>
		
		<!-- Custom scroll bar js-->
		<script src="<?php echo e(url('/')); ?>/assets/plugins/scroll-bar/jquery.mCustomScrollbar.concat.min.js"></script>

	</body>
</html>
